Attribute VB_Name = "FCT_M_VALIDA"
Rem OBJETIVO: Validar que el dgito verificador de la cdula est correcto
Function FCT_DIGVER(lcIdentificacion As String) As Boolean
    Dim lnColumna As Integer
    Dim lcCadena1 As String * 23
    Dim lnResultado As Integer
    Dim lnValor As Integer
    Dim lnDigito As Integer
    Dim lnTotal As Integer
    lnColumna = 1
    lcCadena1 = ""
    Do While lnColumna < 10
        lnResultado = lnColumna Mod 2
        If lnResultado = 0 Then
            lcCadena1 = Trim$(lcCadena1) + Mid$(lcIdentificacion, lnColumna, 1)
        Else
            lcCadena1 = Trim$(lcCadena1) + Str(Val(Mid$(lcIdentificacion, lnColumna, 1)) * 2)
        End If
        lnColumna = lnColumna + 1
    Loop

    lnValor = 0
    lnColumna = 1
    Do While Len(lcCadena1) > lnColumna
        lnValor = lnValor + Val(Mid$(lcCadena1, lnColumna, 1))
        lnColumna = lnColumna + 1
    Loop
    
    lnDigito = 0
    lnTotal = lnValor
    Do While lnResultado <> 0
        lnResultado = lnTotal Mod 10
        If lnResultado = 0 Then
            lnDigito = lnTotal - lnValor
        Else
            lnTotal = lnTotal + 1
        End If
    Loop

    If lnDigito = Val(Mid$(lcIdentificacion, 10, 1)) Then
        FCT_DIGVER = True
    Else
        FCT_DIGVER = False
    End If
    If Val(lcIdentificacion) <= 0 Then
        FCT_DIGVER = False
    End If
End Function

Rem Funcion de validacion completa (Cadenas,Numeros,Fechas)

Function FCT_ValidaDato(TipoDato As String, Valor As Integer) As Integer
    FCT_ValidaDato = Valor%
    Select Case TipoDato$
    Case "N" 'Numeros
        If (Valor% > 46) And (Valor% <> 8) And (Valor% <> 32) And ((Valor% < 48) Or (Valor% > 57)) Then
            FCT_ValidaDato = 0
        End If
    Case "N2" 'Numeros
        If (Valor% <> 46 Or Valor% = 46) And (Valor% <> 8) And (Valor% <> 32) And ((Valor% < 48) Or (Valor% > 57)) Then
            FCT_ValidaDato = 0
        End If
     Case "A" 'Solo letras y en Mayuscula
        If (Valor% <> 8) And (Valor% <> 32) And ((Valor% < 65) Or (Valor% > 90)) And ((Valor% < 97) Or (Valor% > 122)) And ((Valor% > 48) Or (Valor% < 57)) Then
            FCT_ValidaDato = 0
        Else
            FCT_ValidaDato = Asc(UCase$(Chr$(Valor%)))
        End If
    Case "U" 'Mayusculas
        FCT_ValidaDato = Asc(UCase$(Chr$(Valor%)))

    Case "L" 'Minusculas
        FCT_ValidaDato = Asc(LCase$(Chr$(Valor%)))

    Case "CU" 'Convierte a Mayuscula
            If (Valor% <> 8) And (Valor% <> 32) And (Valor% < 65 Or Valor% > 90) And (Valor% < 97 Or Valor% > 122) Then
                FCT_ValidaDato = 0
            Else
                FCT_ValidaDato = Asc(UCase$(Chr$(Valor%)))
            End If

    Case "CL" 'Convierte a Minuscula
            If (Valor% <> 8) And (Valor% <> 32) And (Valor% < 65 Or Valor% > 90) And (Valor% < 97 Or Valor% > 122) Then
                FCT_ValidaDato = 0
            Else
                FCT_ValidaDato = Asc(LCase$(Chr$(Valor%)))
            End If

    Case "M"
        If (Valor% <> 8) And (Valor% <> 32) And (Valor% <> 46) And ((Valor% < 48) Or (Valor% > 57)) Then
            FCT_ValidaDato = 0
        End If
    
    Case "D"  'Solo Fechas permite el (/)
        If (Valor% <> 8) And (Valor% <> 32) And (Valor% <> 47) And ((Valor% < 48) Or (Valor% > 57)) Then
            FCT_ValidaDato = 0
        End If

    End Select

End Function


Sub P_LlenaConsulta(Cadena As String, Consulta As MSFlexGrid, tipo As String)
Dim consul As New ADODB.Recordset
    consul.Open Cadena, conexion, adOpenDynamic
    Consulta.ReDraw = False
    Consulta.Clear
    Consulta.Rows = 2
    Consulta.ColWidth(2) = 500
    P_Formato Consulta, tipo
        Consulta.Row = 1
     While Not consul.EOF
        If tipo = "V" Then
         Consulta.TextMatrix(Consulta.Row, 0) = CStr(consul.Fields(0))
         Consulta.TextMatrix(Consulta.Row, 1) = consul.Fields(1)
         Consulta.TextMatrix(Consulta.Row, 2) = consul.Fields(2)
        Else
        Consulta.TextMatrix(Consulta.Row, 0) = CStr(consul.Fields(0))
        Consulta.TextMatrix(Consulta.Row, 1) = consul.Fields(1)
        End If
        consul.MoveNext
        Consulta.Rows = Consulta.Rows + 1
        Consulta.Row = Consulta.Row + 1
        
    Wend
    
    'If Consulta.Rows > 2 Then
     '   Consulta.RemoveItem (1)
    'End If
    Consulta.ReDraw = True
End Sub

Sub P_Formato(Consulta As MSFlexGrid, tipo As String)
    Consulta.MergeCells = 4
    Consulta.MergeCol(0) = False
    Consulta.MergeCol(1) = False
    Consulta.MergeCol(2) = False
    Consulta.ColWidth(0) = 1000
    
    Consulta.Col = 0
    Consulta.Row = 0
    Consulta.Text = "Cdigo"
    If tipo = "V" Then
     Consulta.Cols = 3
     Consulta.Text = "Cdula"
     Consulta.ColWidth(1) = 2100
     Consulta.ColWidth(2) = 2100
     Consulta.Col = 1
     Consulta.Row = 0
     Consulta.Text = "Nombre"
     Consulta.Col = 2
     Consulta.Row = 0
     Consulta.Text = "Apellido"
     
    Else
    Consulta.ColWidth(1) = 4100
    Consulta.ColWidth(2) = 0
   End If
    Consulta.Col = 2
    Consulta.Row = 0
    If tipo = "N" Then
        Consulta.Text = "Nombre"
    ElseIf tipo = "D" Then
        Consulta.Text = "Descripcin"
    End If
    'Consulta.ColAlignment(1) = 0
    'Consulta.ColAlignment(2) = 0
End Sub

